Option Explicit

Dim WshShell
Dim WshEnv
Dim objFso
Dim objFile
Dim ObjDoc
Dim bRet

Dim EnvVerdict
Dim EnvSerial
Dim EnvPath
Dim EnvName
Const LABEL_TEMPLATE_PATH = "MyLabelPass.lbx"
'Dim testtype

Set WshShell = WScript.CreateObject("WScript.Shell")
Set WshEnv = WshShell.Environment("Process")
Set objFso = CreateObject("Scripting.FileSystemObject") 


REM collecting environment variable "Cfg_SerialNumber" from the QC test
EnvSerial = WshEnv("Cfg_SerialNumber")
If EnvSerial = Empty Then
	MsgBox "Environment variable ''Cfg_SerialNumber'' is empty. Please specify the SN."
End If	

REM collecting environment variable "Ctrl_OverallVerdict" from the QC test	
EnvVerdict = WshEnv("Ctrl_OverallVerdict")
If EnvVerdict = "-1" Then
	MsgBox "Environment variable ''Ctrl_OverallVerdict'' is void. Please set the limits."
	EnvVerdict = "Empty"

REM triggering the lable printing for passed test 	
ElseIf EnvVerdict = "1" Then
	PrintLabel LABEL_TEMPLATE_PATH	
End If

REM adjusting the label layout. This sample program is provided within the program package of the Brother printer.
	'*******************************************************************
	'	Print Module
	'******************************************************************* 
Sub PrintLabel(LabelTemplatePath)
	Dim ObjDoc
	Dim bRet
	
	Set ObjDoc = CreateObject("bpac.Document")
	bRet = ObjDoc.Open(LabelTemplatePath)
	If bRet <> False Then
	    EnvPath = WshEnv("Cfg_DatabasePath") REM collecting environment variable "Cfg_DatabasePath" from the QC test and getting the test name
        'Wscript.Echo "path:" & EnvPath
        Set objFile = objFso.GetFile(EnvPath)
        EnvName = objFso.GetBaseName(objFile)
        'Wscript.Echo "name:" & EnvName
        'testtype = VarType(EnvName)
        'Wscript.Echo "type:" & testtype
	    ObjDoc.GetObject("objProduct").Text = EnvName
		ObjDoc.GetObject("objInfo").Text = "QC Test: PASS"
		If EnvSerial <> Empty Then
		   ObjDoc.SetBarcodeData 0, EnvSerial
		   ObjDoc.StartPrint "", 0
		   ObjDoc.PrintOut 1, 0
		   ObjDoc.EndPrint
		   ObjDoc.Close
		end if
	End If
	Set ObjDoc = Nothing
End Sub

Set WshEnv = Nothing
Set WshShell = Nothing
set objFile = Nothing
set objFso = Nothing
